local beauFont = NumberFontNormal;
local deadFont = GameFontHighlightSmall;
local repuFont = GameFontHighlightLarge;

function IgnoreDamnBar_OnLogin()
	PlayerFrame.noTextPrefix = 1;
	SetTextStatusBarTextPrefix(PlayerFrameHealthBar, nil);
	SetTextStatusBarTextPrefix(PlayerFrameManaBar, nil);
	SetTextStatusBarTextPrefix(MainMenuExpBar, nil);
	PlayerFrameHealthBarText:SetFontObject(beauFont);
	PlayerFrameManaBarText:SetFontObject(beauFont);
	MainMenuBarExpText:SetFontObject(beauFont);
	ReputationWatchStatusBarText:SetFontObject(repuFont);

	SlidingActionBarTexture0:Hide();
	SlidingActionBarTexture1:Hide();
	PetFrameHealthBarText:SetFontObject(beauFont);
	PetFrameManaBarText:SetFontObject(beauFont);
	PetFrameManaBarText:SetPoint("TOP", "PetFrameHealthBarText", "BOTTOM", 0, 2);

	for j = 1, 4, 1 do
		local prefix = "PartyMemberFrame"..j;
		getglobal(prefix.."HealthBarText"):SetFontObject(beauFont);
		getglobal(prefix.."ManaBarText"):SetFontObject(beauFont);
		getglobal(prefix.."ManaBarText"):SetPoint("TOP", prefix.."HealthBarText", "BOTTOM", 0, 2);
	end
end

function IgnoreDamnBar_OnEvent()
	if ( event == "PLAYER_LOGIN" ) then
		IgnoreDamnBar_OnLogin();
	end
end

function IgnoreDamnBar_UpdateTextFont(textStatusBar)
	if ( not textStatusBar.TextString ) then
		return
	end
	local text = textStatusBar.TextString;
	if ( textStatusBar.isZero == 1 ) then
		text:SetFontObject(deadFont);
	else
		if ( text:GetFontObject() ~= beauFont ) then
			text:SetFontObject(beauFont);
		end
	end
end

local frame = CreateFrame("Frame", "IgnoreDamnBar", UIParent);
frame:SetScript("OnEvent", IgnoreDamnBar_OnEvent);
frame:RegisterEvent("PLAYER_LOGIN");

hooksecurefunc(PartyMemberFrame1HealthBarText, "Show", function() IgnoreDamnBar_UpdateTextFont(PartyMemberFrame1HealthBar) end);
hooksecurefunc(PartyMemberFrame2HealthBarText, "Show", function() IgnoreDamnBar_UpdateTextFont(PartyMemberFrame2HealthBar) end);
hooksecurefunc(PartyMemberFrame3HealthBarText, "Show", function() IgnoreDamnBar_UpdateTextFont(PartyMemberFrame3HealthBar) end);
hooksecurefunc(PartyMemberFrame4HealthBarText, "Show", function() IgnoreDamnBar_UpdateTextFont(PartyMemberFrame4HealthBar) end);