/*
 n:
 1.{ Windows ҧ򥻴աAOҥ{Ҭүॿ`B@C
 2.{\HiקAק᪺OҡC
 */

package dark.dungeons.io;

import java.io.*;

/**
 *
 * <p>Title: ˬdӥؿUɮ׮t</p>
 * <p>Description:<br>
* 1.睊:<br>
* Ev 0.1 - ~ 2005/07/29 -
* ɮפjpBɶۦPΤPC<br>
* X@rBHTMLC<br>
* <font color=red>ȾAΩާ@ҦC</font><br>
 * <p />
 * 2.Ѽ<br>
 * CheckFiles.exe source_Path target_Path File_ext_name [check_mod] [show_mode]<br>
 check_mod:<br>
 ALL:  show file list (default)<br>
 DIFF: show file different list<br>
 SAME: show the same file list<br>
 show_mod:<br>
 TEXT:show for DOS(default)<br>
 HTML:show for HTML<br>
<pre>
3.d:
#MsɶBjpۦPAɦW java ɮסAX榡@r
CheckFiles.exe D:\project\temp2\src D:\project\temp1\src .java SAME TEXT

#MsɶBjpPAɦW java ɮסAX榡@r
CheckFiles.exe D:\project\temp2\src D:\project\temp1\src .java DIFF TEXT

#ӥؿUɦW java ɮסAX榡 HTML
CheckFiles.exe D:\project\temp2\src D:\project\temp1\src * ALL HTML

#NGs test.log
CheckFiles.exe D:\project\temp2\src D:\project\temp1\src * > test.log
</pre>
 * </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Dark Dungeons</p>
 * @author Fin
 * @version v 0.1.03
 */
public class CheckFiles {
  //
  private static String VERSION = "0.1.03";
  private static String LAST_UPDATE = "2005/07/29" ;
  //
  private String sourcePath = "";
  private String targetPath = "";

  //
  int sourcePathLength;

  //
  private FileFilter fileFilter = null;
  private StringBuffer buffer = new StringBuffer();

  //
  private String newLine;

  //
  private java.text.SimpleDateFormat sdf;

  //
  private int checkMode = 1;

  //
  private static int CHECK_MODE_ALL = 1;
  private static int CHECK_MODE_DIFF = 2;
  private static int CHECK_MODE_SAME = 3;
  private static int CHECK_MODE_DIFF_SIZE = 4;
  private static int CHECK_MODE_DIFF_DATE = 5;

  //
  private int showMode = 1;

  //
  private static int SHOW_MODE_TEXT = 1;
  private static int SHOW_MODE_HTML = 2;

  public CheckFiles(String sourcePath,
                    String targetPath,
                    String extFileName) {
    this(sourcePath, targetPath, extFileName, "ALL", "TEXT");
  }

  public CheckFiles(String sourcePath,
                    String targetPath,
                    String extFileName,
                    String checkMode) {
    this(sourcePath, targetPath, extFileName, checkMode, "TEXT");
  }

  public CheckFiles(String sourcePath,
                    String targetPath,
                    String extFileName,
                    String checkMode,
                    String showMode) {
    this.sourcePath = sourcePath;
    this.targetPath = targetPath;
    this.fileFilter = new FileFilter(extFileName);
    this.sdf = new java.text.SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
    //
    if (checkMode.equals("DIFF")) {
      this.checkMode = this.CHECK_MODE_DIFF;
    } else if (checkMode.equals("SIZEDIFF")) {
      this.checkMode = this.CHECK_MODE_DIFF_SIZE;
    } else if (checkMode.equals("DATEDIFF")) {
      this.checkMode = this.CHECK_MODE_DIFF_DATE;
    } else if (checkMode.equals("SAME")) {
      this.checkMode = this.CHECK_MODE_SAME;
    } else {
      this.checkMode = this.CHECK_MODE_ALL;
    }
    //
    if (showMode.equals("HTML")) {
      this.showMode = this.SHOW_MODE_HTML;
    } else {
      this.showMode = this.SHOW_MODE_TEXT;
    }
    //
    if (this.showMode == this.SHOW_MODE_TEXT) {
      this.newLine = System.getProperty("line.separator");
    } else {
      this.newLine = "<br>";
    }
  }

  /**
   * ˬdC<br>
   */
  private void check() {

    File sourceDir = new File(this.sourcePath);
    File targetDir = new File(this.targetPath);
    this.buffer.setLength(0);
    if (this.showMode == this.SHOW_MODE_HTML) {
      this.buffer.append("<html><body>");
    }

    // ˬd|
    if (!this.checkPath(sourceDir) || !this.checkPath(targetDir)) {
      return;
    } else {
      //
      this.sourcePathLength = this.sourcePath.length();
      //
      this.buffer.append("Source path:").append(this.sourcePath).append(this.newLine);
      this.buffer.append("Target path:").append(this.targetPath).append(this.newLine);
    }

    System.out.println(this.buffer.toString());
    //
    this.checkFile(sourceDir);
    //
    this.buffer.setLength(0);
    if (this.showMode == this.SHOW_MODE_HTML) {
      this.buffer.append("</body></html>");
    }

  }

  private void checkFile(File dir) {
    // sb
    if (!dir.exists()) {
      return;
    }
    //
    if (dir.isDirectory()) {
      //
      String[] list = dir.list(this.fileFilter);
      for (int i = 0; i < list.length; i++) {
        this.buffer.setLength(0);
        this.buffer.append(dir.getPath()).append("\\").append(list[i]);
        this.checkFile(new File(this.buffer.toString()));
      }
    } else {
      // pwgOɮ
      int lengthOfSourceName = dir.getName().length();
      String subPath;
      //
      if (dir.getPath().length() > this.sourcePathLength) {
        subPath = dir.getPath().substring(this.sourcePathLength + 1,
                                          dir.getPath().length() - lengthOfSourceName);
      } else {
        subPath = "";
      }
      //
      this.buffer.setLength(0);
      this.buffer.append(this.targetPath).append("\\").append(subPath);
      this.buffer.append(dir.getName());
      //
      File target = new File(this.buffer.toString());

      boolean isTargetExist = target.exists();
      //
      String sourceModify = this.sdf.format(new java.util.Date(dir.lastModified()));
      String targetModify = this.sdf.format(new java.util.Date(target.lastModified()));
      //
      long sourceLength = dir.length();
      long targetLength = target.length();
      //
      boolean isTheSame = isTargetExist &&
                          sourceModify.equals(targetModify) &&
                          sourceLength == targetLength;

      if (this.checkMode == this.CHECK_MODE_ALL ||
          (isTheSame && this.checkMode == this.CHECK_MODE_SAME) ||
          (!isTheSame && this.checkMode == this.CHECK_MODE_DIFF)) {

        switch (this.showMode) {
          case 2:
            this.showHTML(dir, sourceModify, sourceLength,
                          target, isTargetExist, targetModify,
                          targetLength);
            break;
          default:
            this.showText(dir, sourceModify, sourceLength,
                          target, isTargetExist, targetModify,
                          targetLength);
        }
      }
    }
  }

  private void showHTML(File source,
                        String sourceModify,
                        long sourceLength,
                        File target,
                        boolean isTargetExist,
                        String targetModify,
                        long targetLength) {
    //
    this.buffer.setLength(0);
    this.buffer.append("<table width='580' border='1' cellpadding='0' cellspacing='0'>");
    this.buffer.append("<tr><td colspan='4'>");
    this.buffer.append("Path");
    this.buffer.append("</td></tr>");
    this.buffer.append("<tr><td colspan='1' align='center'>");
    this.buffer.append("source:</td><td colspan='3'>").append(source.getPath());
    this.buffer.append("</td></tr>");
    this.buffer.append("<tr><td colspan='1' align='center'>");
    this.buffer.append("target:</td><td colspan='3'>").append(target.getPath());
    this.buffer.append("</td></tr>");
    this.buffer.append("<tr><td colspan='2'>");
    this.buffer.append("Source");
    this.buffer.append("</td>");
    this.buffer.append("<td colspan='2'>");
    this.buffer.append("Target");
    this.buffer.append("</td></tr>");
    this.buffer.append("<tr><td colspan='1' align='center'>");
    this.buffer.append("Size</td><td align='center'>Date</td>");
    this.buffer.append("<td align='center'>Size</td><td align='center'>Date</td>");
    this.buffer.append("</tr>");
    //
    this.buffer.append("<tr>");
    this.buffer.append("<td>");
    this.buffer.append(sourceLength);
    this.buffer.append("</td><td>");
    this.buffer.append(sourceModify);
    this.buffer.append("</td>");
    if (isTargetExist) {
      this.buffer.append("<td>");
      this.buffer.append(targetLength);
      this.buffer.append("</td><td>");
      this.buffer.append(targetModify);
      this.buffer.append(this.newLine);
    } else {
      this.buffer.append("<td colspan='2'>");
      this.buffer.append("not found");
    }
    this.buffer.append("</td></tr>");
    this.buffer.append("</table>");
    //
    System.out.println(this.buffer.toString());
    System.out.println("<br>");

  }

  private void showText(File source,
                        String sourceModify,
                        long sourceLength,
                        File target,
                        boolean isTargetExist,
                        String targetModify,
                        long targetLength) {
//
    this.buffer.setLength(0);
    this.buffer.append("Path:").append(this.newLine);
    this.buffer.append("  source:").append(source.getPath()).append(this.newLine);
    this.buffer.append("  target:").append(target.getPath()).append(this.newLine);
    this.buffer.append("Source\t\t\t\tTarget").append(this.newLine);
    this.buffer.append("Size\tDate\t\tSize\tDate").append(this.newLine);
    //
    this.buffer.append(sourceLength).append("\t");
    this.buffer.append(sourceModify);
    this.buffer.append("\t");
    if (isTargetExist) {
      this.buffer.append(targetLength).append("\t");
      this.buffer.append(targetModify);
      this.buffer.append(this.newLine);
    } else {
      this.buffer.append("not found");
    }
    //
    System.out.println(this.buffer.toString());
    System.out.println("");

  }

  /**
   * ˬd|C<br>
   * @param dir File
   * @return boolean
   */
  private boolean checkPath(File dir) {
    if (!dir.isDirectory()) {
      System.out.println("ǤJ| [" + dir.getAbsolutePath() + "[sbC");
      return false;
    }
    return true;

  }

  private class FileFilter
      implements FilenameFilter {

    String extFileName;

    FileFilter(String extFileName) {
      this.extFileName = extFileName;
    }

    /**
     * accept
     *
     * @param dir File
     * @param name String
     * @return boolean
     */
    public boolean accept(File dir, String name) {
      File file = new File(dir.getPath() + "\\" + name);
      if (file.isDirectory() ||
          this.extFileName == null ||
          this.extFileName.length() == 0 ||
          this.extFileName.equals("*")) {
        return true;
      }

      if (name.endsWith(this.extFileName)) {
        return true;
      }
      return false;

    }

  }

  private static void helpPage() {
    System.out.println("{\:ˬdӥؿUɮ׮tC");
    System.out.println("- Version:\t"+CheckFiles.VERSION);
    System.out.println("- Date:   \t"+CheckFiles.LAST_UPDATE);
    System.out.println("- Author :\tFin");
    System.out.println("");
    System.out.println("覡:");
    System.out.println("  CheckFiles.exe source_Path target_Path File_ext_name [check_mod] [show_mode]");
    System.out.println("    check_mod:");
    System.out.println("      ALL:\tshow file list (default)");
    System.out.println("      DIFF:\tshow file different list");
//      System.out.println("      SIZEDIFF:\tshow only file size different list");
//      System.out.println("      DATEDIFF:\tshow only file date different list");
    System.out.println("      SAME:\tshow the same file list");
    System.out.println("    show_mod:");
    System.out.println("      TEXT:\tshow for DOS(default)");
    System.out.println("      HTML:\tshow for HTML");
    System.out.println("");
    System.out.println("Ҧ:");
    System.out.println("  CheckFiles.exe [? | help | /h]");
    System.out.println("");
    System.out.println("d:");
    System.out.println("  #MsɶBjpۦPAɦW java ɮסAX榡@r");
    System.out.println("  CheckFiles.exe D:\\project\\temp2\\src D:\\project\\temp1\\src .java SAME TEXT");
    System.out.println("");
    System.out.println("  #MsɶBjpPAɦW java ɮסAX榡@r");
    System.out.println("  CheckFiles.exe D:\\project\\temp2\\src D:\\project\\temp1\\src .java DIFF TEXT");
    System.out.println("");
    System.out.println("  #ӥؿUɦW java ɮסAX榡 HTML");
    System.out.println("  CheckFiles.exe D:\\project\\temp2\\src D:\\project\\temp1\\src * ALL HTML");
    System.out.println("");
    System.out.println("  #NGs test.log");
    System.out.println("  CheckFiles.exe D:\\project\\temp2\\src D:\\project\\temp1\\src * > test.log");

  }

  public static void main(String[] args) {

    boolean isHelp = false;

    for (int i = 0, length = (args == null ? 0 : args.length); i < length; i++) {
      if ( args[i] != null ) {
        if ( args[i].indexOf("?") >= 0 ||
             args[i].toUpperCase().indexOf("HELP") >= 0 ||
             args[i].toUpperCase().indexOf("/H") >= 0 ) {
          isHelp = true;
          break;
        }
      }
    }

    if (isHelp || args == null || args.length < 3) {
      CheckFiles.helpPage();
      System.exit(0);
    }
    CheckFiles test = null;
    if (args.length == 5) {
      test = new CheckFiles(args[0], args[1], args[2], args[3], args[4]);
    } else if (args.length == 4) {
      test = new CheckFiles(args[0], args[1], args[2], args[3]);
    } else if (args.length == 3) {
      test = new CheckFiles(args[0], args[1], args[2]);
    } else {
      System.exit(0);
    }
    test.check();
  }

}
